<?php
session_start();
require_once '../config/db.php';
require_once '../auth/auth.php';
require_once '../includes/auth_check.php';
require_once '../helpers/helpers.php';
require_once '../helpers/favicon_helper.php';
require_once '../helpers/permission_modal.php';

// Check if user has any inventory-related permissions
$inventoryPermissions = [
    'view_inventory', 'manage_inventory', 'adjust_stock', 'add_stock', 'edit_stock', 'delete_stock'
];

if (!hasAnyPermission($inventoryPermissions)) {
    $_SESSION['error'] = "You don't have permission to access inventory management.";
    header('Location: dashboard.php');
    exit;
}

// Handle stock adjustment
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['adjust_stock'])) {
    // Check if user has permission to adjust stock
    if (!hasPermission('adjust_stock')) {
        $error = 'You do not have permission to adjust stock.';
    } else {
        try {
            $product_id = $_POST['product_id'];
            $adjustment = $_POST['adjustment'];
            $reason = $_POST['reason'];
            
            // Get current stock
            $stmt = $pdo->prepare("SELECT quantity, name FROM products WHERE id = ?");
            $stmt->execute([$product_id]);
            $product = $stmt->fetch();
            
            if ($product) {
                $new_quantity = $product['quantity'] + $adjustment;
                
                // Update stock
                $stmt = $pdo->prepare("UPDATE products SET quantity = ? WHERE id = ?");
                if ($stmt->execute([$new_quantity, $product_id])) {
                    $details = sprintf(
                        "Product: %s (ID: %d), Old Quantity: %d, Adjustment: %+d, New Quantity: %d, Reason: %s",
                        $product['name'],
                        $product_id,
                        $product['quantity'],
                        $adjustment,
                        $new_quantity,
                        $reason
                    );
                    logSystemAction('stock_adjusted', $details);
                    $success = 'Stock adjusted successfully!';
                }
            }
        } catch (PDOException $e) {
            $error = 'Error adjusting stock: ' . $e->getMessage();
        }
    }
} 
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Inventory - EDDUH COMPUTERS</title>
    <?php echo getFaviconLink($pdo); ?>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>
    <!-- Rest of the file remains unchanged -->
    
    <?php 
    // Add permission modal components
    echo getPermissionModalCSS();
    echo getPermissionModalHTML();
    echo getPermissionModalJS();
    ?>
    <?php echo getUniversalPermissionModalHTML(); ?>
    <?php echo getUniversalPermissionModalJS(); ?>
</body>
</html> 